/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.api;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.every_compat.EveryCompat;
import net.mehvahdjukaar.every_compat.api.CompatModule;
import net.mehvahdjukaar.every_compat.api.EntrySet;
import net.mehvahdjukaar.every_compat.configs.WoodConfigs;
import net.mehvahdjukaar.every_compat.misc.ResourcesUtils;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.item.BlockTypeBasedBlockItem;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.resources.BlockTypeResTransformer;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynClientResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1079;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5614;
import net.minecraft.class_6862;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleEntrySet<T extends BlockType, B extends class_2248>
extends EntrySet<T, B> {
    private final Class<T> type;
    private final Pattern nameScheme;
    protected final Supplier<T> baseType;
    protected final Supplier<B> baseBlock;
    public final String postfix;
    @Nullable
    public final String prefix;
    protected final Function<T, @Nullable B> blockFactory;
    @Nullable
    protected final @Nullable TriFunction<T, B, // Could not load outer class - annotation placement on inner may be incorrect
    class_1792.class_1793, @Nullable class_1792> itemFactory;
    @Nullable
    protected final TileHolder<?> tileHolder;
    protected final Supplier<class_1761> tab;
    protected final boolean copyLoot;
    protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
    protected final Set<Supplier<class_2960>> recipeLocations = new HashSet<Supplier<class_2960>>();
    protected final Set<Pair<class_2960, @Nullable class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
    @Nullable
    protected final @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier;
    @Nullable
    protected final Supplier<Supplier<class_1921>> renderType;
    @Nullable
    protected final Consumer<BlockTypeResTransformer<T>> extraTransform;

    public SimpleEntrySet(Class<T> type, String name, @Nullable String prefix, Function<T, B> blockSupplier, Supplier<B> baseBlock, Supplier<T> baseType, Supplier<class_1761> tab, boolean copyLoot, @Nullable TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory, @Nullable TileHolder<?> tileFactory, @Nullable Supplier<Supplier<class_1921>> renderType, @Nullable @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteSupplier, @Nullable Consumer<BlockTypeResTransformer<T>> extraTransform) {
        super((String)(prefix == null ? "" : prefix + (name.isEmpty() ? "" : "_")) + name);
        this.postfix = name;
        this.blockFactory = blockSupplier;
        this.prefix = prefix;
        this.tileHolder = tileFactory;
        this.tab = tab;
        this.copyLoot = copyLoot;
        this.baseBlock = baseBlock;
        this.baseType = baseType;
        this.itemFactory = itemFactory;
        this.type = type;
        this.extraTransform = extraTransform;
        this.renderType = renderType;
        this.paletteSupplier = paletteSupplier;
        this.nameScheme = this.prefix != null ? (this.postfix.isEmpty() ? Pattern.compile("^" + prefix + "_(.+?)$") : Pattern.compile("^" + prefix + "_(.+?)_" + this.postfix + "$")) : Pattern.compile("^(.+?)_" + this.postfix + "$");
    }

    public TileHolder<?> getTileHolder() {
        return this.tileHolder;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type;
    }

    public B getBaseBlock() {
        return (B)((class_2248)this.baseBlock.get());
    }

    public T getBaseType() {
        return (T)((BlockType)this.baseType.get());
    }

    public String getEquivalentBlock(CompatModule module, String oldName, String woodFrom) {
        BlockType w;
        String wood = this.parseWoodType(oldName);
        if (wood != null && (w = BlockSetAPI.getBlockSet(this.getTypeClass()).get(new class_2960(woodFrom, wood))) != null) {
            return module.shortenedId() + "/" + w.getNamespace() + "/" + oldName;
        }
        return null;
    }

    @Nullable
    public String parseWoodType(String oldName) {
        Matcher m = this.nameScheme.matcher(oldName);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void addTranslations(CompatModule module, AfterLanguageLoadEvent lang) {
        this.blocks.forEach((w, v) -> LangBuilder.addDynamicEntry((AfterLanguageLoadEvent)lang, (String)("block_type." + module.getModId() + "." + this.typeName), (BlockType)w, (class_2248)v));
    }

    @Override
    public void registerWoodBlocks(CompatModule module, Registrator<class_2248> registry, Collection<WoodType> woodTypes) {
        if (WoodType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, woodTypes);
        }
    }

    @Override
    public void registerLeavesBlocks(CompatModule module, Registrator<class_2248> registry, Collection<LeavesType> leavesTypes) {
        if (LeavesType.class == this.getTypeClass()) {
            this.registerBlocks(module, registry, leavesTypes);
        }
    }

    @Override
    public void registerBlocks(CompatModule module, Registrator<class_2248> registry, Collection<T> woodTypes) {
        class_2248 base = (class_2248)this.baseBlock.get();
        if (base == null || base == class_2246.field_10124) {
            throw new UnsupportedOperationException("Base block cant be null");
        }
        ((BlockType)this.baseType.get()).addChild(this.getChildKey(module), (Object)base);
        for (BlockType w : woodTypes) {
            class_2248 block;
            String name = this.getBlockName(w);
            String fullName = module.shortenedId() + "/" + w.getNamespace() + "/" + name;
            if (w.isVanilla() || module.isEntryAlreadyRegistered(name, w, (class_2378<?>)class_2378.field_11146) || (block = (class_2248)this.blockFactory.apply(w)) == null) continue;
            this.blocks.put(w, block);
            registry.register(EveryCompat.res(fullName), (Object)block);
            w.addChild(this.getChildKey(module), (Object)block);
        }
    }

    @NotNull
    public String getBlockName(T w) {
        String name;
        if (this.prefix != null) {
            name = this.prefix + "_" + w.getTypeName();
            if (!this.postfix.isEmpty()) {
                name = name + "_" + this.postfix;
            }
        } else {
            name = w.getTypeName() + "_" + this.postfix;
        }
        return name;
    }

    protected class_1761 getTab(T w, B b) {
        return WoodConfigs.isEntryEnabled(w, b) ? (EveryCompat.MOD_TAB != null ? EveryCompat.MOD_TAB : this.tab.get()) : null;
    }

    @Override
    public void registerItems(CompatModule module, Registrator<class_1792> registry) {
        this.blocks.forEach((w, value) -> {
            class_1761 tab = this.getTab(w, value);
            Object i = this.itemFactory != null ? (class_1792)this.itemFactory.apply(w, value, (Object)new class_1792.class_1793().method_7892(tab)) : new BlockTypeBasedBlockItem(value, new class_1792.class_1793().method_7892(tab), w);
            if (i != null) {
                this.items.put(w, i);
                registry.register(Utils.getID((class_2248)value), i);
            }
        });
    }

    @Override
    public void registerTiles(CompatModule module, Registrator<class_2591<?>> registry) {
        if (this.tileHolder != null) {
            class_2591<?> tile = this.tileHolder.createInstance((class_2248[])this.blocks.values().toArray(class_2248[]::new));
            registry.register(EveryCompat.res(module.shortenedId() + "_" + this.getName()), tile);
        }
    }

    @Override
    public void registerEntityRenderers(CompatModule simpleModule, ClientPlatformHelper.BlockEntityRendererEvent event) {
        if (this.tileHolder != null) {
            // empty if block
        }
    }

    @Override
    public void setRenderLayer() {
        if (this.renderType != null) {
            this.blocks.values().forEach(t -> ClientPlatformHelper.registerRenderType((class_2248)t, (class_1921)this.renderType.get().get()));
        }
    }

    @Override
    public void generateTags(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        if (!this.tags.isEmpty()) {
            for (Map.Entry<class_2960, Set<class_5321<?>>> tb : this.tags.entrySet()) {
                SimpleTagBuilder builder = SimpleTagBuilder.of((class_2960)tb.getKey());
                for (Map.Entry entry : this.blocks.entrySet()) {
                    if (!WoodConfigs.isEntryEnabled((BlockType)entry.getKey(), entry.getValue())) continue;
                    builder.addEntry(entry.getValue());
                }
                for (class_5321 class_53212 : tb.getValue()) {
                    pack.addTag(builder, class_53212);
                }
            }
        }
    }

    @Override
    public void generateLootTables(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        if (this.copyLoot) {
            class_2960 reg = Utils.getID((class_2248)((class_2248)this.baseBlock.get()));
            ResourcesUtils.addBlockResources(module.getModId(), manager, (DynamicResourcePack)pack, this.blocks, ((BlockType)this.baseType.get()).getTypeName(), ResType.BLOCK_LOOT_TABLES.getPath(reg));
        } else {
            this.blocks.forEach((wood, value) -> pack.addSimpleBlockLootTable(value));
        }
    }

    @Override
    public void generateRecipes(CompatModule module, DynamicDataPack pack, class_3300 manager) {
        this.recipeLocations.forEach(r -> {
            class_2960 res = (class_2960)r.get();
            try {
                ResourcesUtils.addBlocksRecipes(manager, pack, this.items, res, (BlockType)this.baseType.get());
            }
            catch (Exception e) {
                EveryCompat.LOGGER.error("Failed to generate recipes for template at location {} ", (Object)res);
            }
        });
    }

    @Override
    public void generateModels(CompatModule module, DynClientResourcesProvider handler, class_3300 manager) {
        ResourcesUtils.addStandardResources(module.getModId(), manager, handler, this.blocks, (BlockType)this.baseType.get(), this.extraTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateTextures(CompatModule module, DynClientResourcesProvider handler, class_3300 manager) {
        if (this.textures.isEmpty()) {
            return;
        }
        ArrayList<TextureImage> images = new ArrayList<TextureImage>();
        try {
            HashMap respriters = new HashMap();
            for (Pair<class_2960, class_2960> pair : this.textures) {
                class_2960 textureId = (class_2960)pair.getFirst();
                try {
                    Respriter r;
                    TextureImage main = TextureImage.open((class_3300)manager, (class_2960)textureId);
                    images.add(main);
                    class_2960 m = (class_2960)pair.getSecond();
                    if (m != null) {
                        TextureImage mask = TextureImage.open((class_3300)manager, (class_2960)m);
                        images.add(main);
                        r = Respriter.masked((TextureImage)main, (TextureImage)mask);
                    } else {
                        r = Respriter.of((TextureImage)main);
                    }
                    respriters.put(textureId, r);
                }
                catch (Exception e) {
                    EveryCompat.LOGGER.error("Failed to read block texture at: {}", pair, (Object)e);
                }
            }
            for (Map.Entry entry : this.blocks.entrySet()) {
                class_2248 b = (class_2248)entry.getValue();
                BlockType w = (BlockType)entry.getKey();
                if (!WoodConfigs.isEntryEnabled(w, (Object)b)) continue;
                class_2960 blockId = Utils.getID((class_2248)b);
                List targetPalette = null;
                class_1079 animation = null;
                if (this.paletteSupplier != null) {
                    Pair<List<Palette>, class_1079> pal = this.paletteSupplier.apply(w, manager);
                    animation = (class_1079)pal.getSecond();
                    targetPalette = (List)pal.getFirst();
                } else {
                    class_1935 m = w.mainChild();
                    class_2248 mainBlock = null;
                    if (m instanceof class_2248) {
                        class_2248 bb;
                        mainBlock = bb = (class_2248)m;
                    } else if (m instanceof class_1747) {
                        class_1747 bii = (class_1747)m;
                        mainBlock = bii.method_7711();
                    }
                    if (mainBlock == null) {
                        throw new UnsupportedOperationException("You need to provide a palette supplier for non wood type based blocks");
                    }
                    try (TextureImage plankTexture22 = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)mainBlock));){
                        targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture22);
                        animation = plankTexture22.getMetadata();
                    }
                    catch (Exception plankTexture22) {
                        // empty catch block
                    }
                }
                if (targetPalette == null) {
                    EveryCompat.LOGGER.error("Could not get texture palette for block {} : ", (Object)b);
                    continue;
                }
                class_1079 finalAnimation = animation;
                List finalTargetPalette = targetPalette;
                int oldSize = ((Palette)finalTargetPalette.get(0)).size();
                for (Map.Entry re : respriters.entrySet()) {
                    if (oldSize != ((Palette)finalTargetPalette.get(0)).size()) {
                        throw new RuntimeException("This should not happen");
                    }
                    String oldPath = ((class_2960)re.getKey()).method_12832();
                    String newId = BlockTypeResTransformer.replaceTypeNoNamespace((String)oldPath, (BlockType)w, (class_2960)blockId, (String)((BlockType)this.baseType.get()).getTypeName());
                    Respriter respriter = (Respriter)re.getValue();
                    if (this.type == WoodType.class) {
                        module.addWoodTexture((WoodType)w, handler, manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                        continue;
                    }
                    handler.addTextureIfNotPresent(manager, newId, () -> respriter.recolorWithAnimation(finalTargetPalette, finalAnimation));
                }
            }
        }
        catch (Exception e) {
            EveryCompat.LOGGER.error("Could not generate any block texture for entry set {} : ", (Object)module.modRes(this.getName()), (Object)e);
        }
        finally {
            for (TextureImage t : images) {
                t.close();
            }
        }
    }

    public static <T extends BlockType, B extends class_2248> Builder<T, B> builder(Class<T> type, String name, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, null, baseType, baseBlock, blockSupplier);
    }

    public static <T extends BlockType, B extends class_2248> Builder<T, B> builder(Class<T> type, String name, String prefix, Supplier<B> baseBlock, Supplier<T> baseType, Function<T, B> blockSupplier) {
        return new Builder<T, B>(type, name, prefix, baseType, baseBlock, blockSupplier);
    }

    public static class TileHolder<H extends class_2586> {
        protected final BiFunction<class_2338, class_2680, H> tileFactory;
        protected Supplier<class_5614<H>> renderer = null;
        public class_2591<? extends H> tile = null;

        public TileHolder(BiFunction<class_2338, class_2680, H> tileFactory) {
            this.tileFactory = tileFactory;
        }

        public class_2591<? extends H> get() {
            return this.tile;
        }

        public class_2591<? extends H> createInstance(class_2248 ... blocks) {
            if (this.tile != null) {
                throw new UnsupportedOperationException("tile has already been created");
            }
            this.tile = PlatformHelper.newBlockEntityType(this.tileFactory::apply, (class_2248[])blocks);
            return this.tile;
        }
    }

    public static class Builder<T extends BlockType, B extends class_2248> {
        protected final Class<T> type;
        protected final Supplier<T> baseType;
        protected final Supplier<B> baseBlock;
        protected final String name;
        @Nullable
        protected final String prefix;
        protected Supplier<class_1761> tab = () -> class_1761.field_7928;
        protected boolean copyLoot = false;
        protected final Function<T, B> blockFactory;
        @Nullable
        protected TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory;
        @Nullable
        protected TileHolder<?> tileFactory;
        @Nullable
        protected Supplier<Supplier<class_1921>> renderType = null;
        @Nullable
        protected @Nullable BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> palette = null;
        protected final Map<class_2960, Set<class_5321<?>>> tags = new HashMap();
        protected final Set<Supplier<class_2960>> recipes = new HashSet<Supplier<class_2960>>();
        protected final Set<Pair<class_2960, @Nullable class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
        protected Consumer<BlockTypeResTransformer<T>> extraModelTransform = null;

        protected Builder(Class<T> type, String name, @Nullable String prefix, Supplier<T> baseType, Supplier<B> baseBlock, Function<T, B> blockFactory) {
            this.baseType = baseType;
            this.baseBlock = baseBlock;
            this.name = name;
            this.prefix = prefix;
            this.blockFactory = blockFactory;
            this.type = type;
        }

        public SimpleEntrySet<T, B> build() {
            SimpleEntrySet<T, B> e = new SimpleEntrySet<T, B>(this.type, this.name, this.prefix, this.blockFactory, this.baseBlock, this.baseType, this.tab, this.copyLoot, this.itemFactory, this.tileFactory, this.renderType, this.palette, this.extraModelTransform);
            e.recipeLocations.addAll(this.recipes);
            e.tags.putAll(this.tags);
            e.textures.addAll(this.textures);
            return e;
        }

        public <H extends class_2586> Builder<T, B> addTile(BiFunction<class_2338, class_2680, H> tileFactory) {
            this.tileFactory = new TileHolder<H>(tileFactory);
            return this;
        }

        public Builder<T, B> addCustomItem(TriFunction<T, B, class_1792.class_1793, class_1792> itemFactory) {
            this.itemFactory = itemFactory;
            return this;
        }

        public Builder<T, B> addModelTransform(Consumer<BlockTypeResTransformer<T>> transform) {
            this.extraModelTransform = transform;
            return this;
        }

        public Builder<T, B> noItem() {
            this.itemFactory = (a, b, c) -> null;
            return this;
        }

        public Builder<T, B> setTab(Supplier<class_1761> tab) {
            this.tab = tab;
            return this;
        }

        public Builder<T, B> useLootFromBase() {
            this.copyLoot = true;
            return this;
        }

        public Builder<T, B> setRenderType(Supplier<Supplier<class_1921>> renderType) {
            this.renderType = renderType;
            return this;
        }

        public Builder<T, B> addTag(class_2960 location, class_5321<?> registry) {
            Set s = this.tags.computeIfAbsent(location, b -> new HashSet());
            s.add(registry);
            return this;
        }

        public Builder<T, B> addTag(class_6862<?> tag, class_5321<?> registry) {
            this.addTag(tag.comp_327(), registry);
            return this;
        }

        public Builder<T, B> defaultRecipe() {
            this.recipes.add(() -> Utils.getID((class_2248)((class_2248)this.baseBlock.get())));
            return this;
        }

        public Builder<T, B> addRecipe(class_2960 resourceLocation) {
            this.recipes.add(() -> resourceLocation);
            return this;
        }

        public Builder<T, B> addTexture(class_2960 resourceLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)resourceLocation, null));
            return this;
        }

        public Builder<T, B> addTextureM(class_2960 textureLocation, class_2960 maskLocation) {
            this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)textureLocation, (Object)maskLocation));
            return this;
        }

        public Builder<T, B> setPalette(BiFunction<T, class_3300, Pair<List<Palette>, @Nullable class_1079>> paletteProvider) {
            this.palette = paletteProvider;
            return this;
        }

        public Builder<T, B> createPaletteFromOak(Consumer<Palette> paletteTransform) {
            return this.setPalette((w, m) -> {
                Pair pair;
                block8: {
                    TextureImage plankTexture = TextureImage.open((class_3300)m, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)m, (class_2248)((WoodType)w).planks));
                    try {
                        List targetPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                        targetPalette.forEach(paletteTransform);
                        pair = Pair.of((Object)targetPalette, (Object)plankTexture.getMetadata());
                        if (plankTexture == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (plankTexture != null) {
                                try {
                                    plankTexture.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(String.format("Failed to generate palette for %s : %s", w, e));
                        }
                    }
                    plankTexture.close();
                }
                return pair;
            });
        }
    }
}

